<?php
if (true) {
  header("Content-type: application/vnd-ms-excel");
  header("Content-Disposition: attachment; filename=Reporting-Machine (". $name .") " . date('Ymd_His') . ".xls");
}
?>


<!DOCTYPE html>
<html>
<head>

<!-- Core CSS -->
<link rel="stylesheet" href="<?= base_url() ?>assets/vendor/css/core.css" class="template-customizer-core-css" />
<link rel="stylesheet" href="<?= base_url() ?>assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
<link rel="stylesheet" href="<?= base_url() ?>assets/css/demo.css" />
<title>Machine Reporting</title>

  <style>
      body {
          font-family: Arial, sans-serif;
      }
      table {
          width: 100%;
          border-collapse: collapse;
          margin-top: 10px;
      }
      th, td {
          border: 1px solid black;
          padding: 8px;
          text-align: left;
      }
      th {
          background-color: #f2f2f2;
      }
      .center-text {
          text-align: center;
          font-weight: bold;
      }

       .vertical-text {
            writing-mode: vertical-rl; /* Membuat teks vertikal */
            text-align: center;
            vertical-align: middle;
            transform: rotate(180deg); /* Membalik agar teks menghadap ke kanan */
        }
    </style>

  </style>


</head>
<body>


    <h2 class="center-text" style="margin-top: 40px;">MACHINE DATA REPORT</h2>
    <p><strong>Date</strong> : <?= date('d-m-Y', strtotime($start)) ?> - <?= date('d-m-Y', strtotime($end)) ?></p>
    <p><strong>Lokasi</strong> : Machining Area</p>

    <h3 class="center-text" style="margin-top: 40px; margin-bottom: 20px;" ><em>Preventive Maintenance Routine (PMR)</em></h3>

    <table>
        <tr>
            <th class="center-text">No</th>
            <th class="center-text">Area</th>
            <th class="center-text">Task</th>
            <th class="center-text">Standart</th>
            <th class="center-text">Value</th>
        </tr>
        <tr>
            <td rowspan="6" class="center-text" style="vertical-align: middle;">1</td>
            <td rowspan="6" class="vertical-text"><?= $name ?></td>
            <td>Average RPM</td>
            <td>25 - 1600 RPM</td>
            <td><?= $rpm ?> RPM</td>
        </tr>
        <tr>
            <td>Average Current</td>
            <td>3 - 9,9 A</td>
            <td><?= $current ?> Amp</td>
        </tr>
        <tr>
            <td>Temperature Machine</td>
            <td>&lt; 100 C</td>
            <td><?= $temperature ?> C</td>
        </tr>
        <tr>
            <td>Total Hours</td>
            <td>&lt; <?= $target ?> h</td>
            <td><?= $total ?> h</td>
        </tr>
        <tr>
            <td>Connection</td>
            <td>Terhubung</td>
            <td><?= strtoupper($is_connect)=="ON" ? "Terhubung" : "Tidak Terhubung" ?></td>
        </tr>
        <tr>
            <td>Allert</td>
            <td>-</td>
            <td>
              <div>
                <?php if( floatval($current) < 3 || floatval($current) > 9.9 ): ?>
                  <span>- Average current is not normal</span>
                  <br>
                <?php endif; ?>

                <?php if(floatval($temperature) >= 100): ?>
                  <span>- The temperature value has been over</span>
                  <br>
                <?php endif; ?>
              </div>

            </td>
        </tr>
    </table>

    <script type="text/javascript">
        
      // window.onload = function() {
      //   window.print();
      // };


    </script>

</body>
</html>